% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odbc-connection.R
\docType{data}
\name{SUPPORTED_CONNECTION_ATTRIBUTES}
\alias{SUPPORTED_CONNECTION_ATTRIBUTES}
\alias{ConnectionAttributes}
\title{Supported Connection Attributes}
\description{
These (pre) connection attributes are supported and can be passed as
part of the \code{dbConnect} call in the named list \code{attributes} parameter:
}
\details{
\itemize{
\item \code{azure_token}: This should be a string scalar; in particular Azure Active
Directory authentication token.  Only for use with Microsoft SQL Server and
with limited support away from the OEM Microsoft driver.
}
}
\examples{
\dontrun{
conn <- dbConnect(
  odbc::odbc(),
  dsn = "my_azure_mssql_db",
  Encrypt = "yes",
  attributes = list("azure_token" = .token)
)
}
}
\keyword{internal}
