% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_local.R
\name{pull_local}
\alias{pull_local}
\title{pull_local}
\usage{
pull_local(target = "", briefcase = "odkBriefcase_latest", id = "",
  to = "", from = "", pem = NULL)
}
\arguments{
\item{target}{Path to directory of ODK Briefcase \code{.jar} file. Directory
path should match directory path used when calling \code{get_briefcase()}.
If ODK Briefcase \code{.jar} file was downloaded manually from \url{https://opendatakit.org},
\code{target} should match the directory path where \code{.jar} file has
been downloaded into.}

\item{briefcase}{Filename of the downloaded ODK Briefcase \code{.jar} file.
Default is \code{odkBriefcase_latest} to match the default filename used
by \code{get_briefcase()}. If ODK Briefcase \code{.jar} file was
downloaded manually from \url{https://opendatakit.org}, filename should
match the default filename used by Open Data Kit which is usually
"ODK Briefcase vX.Y.Z Production.jar" where vX.Y.Z is the version number}

\item{id}{Form ID of form to be pulled}

\item{to}{Destination directory for pulled ODK forms}

\item{from}{Source ODK directory (\code{/odk}) from ODK Collect mobile client}

\item{pem}{If form to be pulled is encrypted, a PEM private key file would be
required to pull forms; default is NULL; if form is encrypted, provide path
to PEM file}
}
\value{
Folder in destination directory named "ODK Briefcase Storage"
containing forms pulled from local ODK folder
}
\description{
Pull ODK forms from a local ODK folder (\code{/odk}) collected from
ODK Collect mobile clients
}
\examples{
# Pull forms from a local ODK folder to current working directory
\dontrun{
  dirPath <- tempdir()
  get_briefcase(destination = dirPath)
  pull_local(target = dirPath,
             id = "stakeholders",
             from = system.file("odk", package = "odkr"),
             to = dirPath)
}

}
