% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timed_evaluation.R
\name{do.call_timed}
\alias{do.call_timed}
\title{Measure computation time}
\usage{
do.call_timed(what, args, units = "secs")
}
\arguments{
\item{what}{Passed to \code{\link[base]{do.call}}.}

\item{args}{Passed to \code{\link[base]{do.call}}.}

\item{units}{Passed to \code{\link[base]{difftime}}.}
}
\value{
A list of the two elements \code{"result"} (the results of the \code{do.call}
call) and \code{"time"} (the computation time).
}
\description{
This function measures the computation time of a \code{do.call} call.
}
\details{
This function is a wrapper for \code{\link[base]{do.call}}.
}
\examples{
\dontrun{
what <- function(s) { Sys.sleep(s); return(s) }
args <- list(s = 1)
do.call_timed(what = what, args = args)
}

}
