% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary_helpers.R
\name{Dictionary}
\alias{Dictionary}
\title{Dictionary R6 Object}
\description{
Provides a simple key-value interface based on R6.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{keys}}{A \code{character} \code{vector} of available keys.}

\item{\code{alias}}{A \code{list} of available keys per alias value.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Dictionary-new}{\code{Dictionary$new()}}
\item \href{#method-Dictionary-add}{\code{Dictionary$add()}}
\item \href{#method-Dictionary-get}{\code{Dictionary$get()}}
\item \href{#method-Dictionary-remove}{\code{Dictionary$remove()}}
\item \href{#method-Dictionary-print}{\code{Dictionary$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Dictionary-new"></a>}}
\if{latex}{\out{\hypertarget{method-Dictionary-new}{}}}
\subsection{Method \code{new()}}{
initializing a \code{Dictionary} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dictionary$new(
  key_name,
  alias_name = NULL,
  value_names = character(),
  value_assert = alist(),
  allow_overwrite = TRUE,
  keys_reserved = character(),
  alias_choices = NULL,
  dictionary_name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key_name}}{A single \code{character}, the name for the key variable.}

\item{\code{alias_name}}{Optionally a single \code{character}, the name for the alias variable.
Can also be \code{NULL} (default) for no alias.}

\item{\code{value_names}}{A \code{character} (\code{vector}), the names of the values connected to a
key.}

\item{\code{value_assert}}{A \code{alist} with check functions for supplied values. For each element
in \code{value_names}, \code{values_assert} \emph{can} have an identically named
element of the form \code{checkmate::assert_*(...)}, where \code{...} can be
any arguments for the assertion function except for the \code{x} argument.}

\item{\code{allow_overwrite}}{Either \code{TRUE} (default) to allow overwriting existing keys with new
values, or \code{FALSE} else. Duplicate keys are never allowed.}

\item{\code{keys_reserved}}{A \code{character} (\code{vector}) of names that must not be used as keys.}

\item{\code{alias_choices}}{Optionally a \code{character} \code{vector} of possible values for the alias.
Can also be \code{NULL}, then all alias values are allowed.}

\item{\code{dictionary_name}}{Optionally a single \code{character}, a name for the dictionary.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{Dictionary} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Dictionary-add"></a>}}
\if{latex}{\out{\hypertarget{method-Dictionary-add}{}}}
\subsection{Method \code{add()}}{
adding an element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dictionary$add(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Values for
\itemize{
\item the key variable \code{key_name} (must be a single \code{character}),
\item the alias variable \code{alias_name} (optionally, must then be a
\code{character} \code{vector}),
\item all the variables specified for \code{value_names} (if any, they must
comply to the \code{value_assert} checks).
}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly the \code{Dictionary} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Dictionary-get"></a>}}
\if{latex}{\out{\hypertarget{method-Dictionary-get}{}}}
\subsection{Method \code{get()}}{
getting elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dictionary$get(key, value = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{A single \code{character}, a value for the key variable \code{key_name}.
Use the \code{$keys} method for available keys.}

\item{\code{value}}{Optionally a single \code{character}, one of the elements in
\code{value_names}, selecting the required value.
Can also be \code{NULL} (default) for all values connected to the
\code{key}, returned as a \code{list}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the selected value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Dictionary-remove"></a>}}
\if{latex}{\out{\hypertarget{method-Dictionary-remove}{}}}
\subsection{Method \code{remove()}}{
removing elements (and associated alias, if any)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dictionary$remove(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{A single \code{character}, a value for the key variable \code{key_name}.
Use the \code{$keys} method for available keys.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly the \code{Dictionary} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Dictionary-print"></a>}}
\if{latex}{\out{\hypertarget{method-Dictionary-print}{}}}
\subsection{Method \code{print()}}{
printing details of the dictionary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Dictionary$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
invisibly the \code{Dictionary} object
}
}
}
