% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_indices.R
\name{matrix_indices}
\alias{matrix_indices}
\title{Get \code{matrix} indices}
\usage{
matrix_indices(x, prefix = "", exclude_diagonal = FALSE)
}
\arguments{
\item{x}{[\code{matrix}]\cr
A \code{matrix}.}

\item{prefix}{[\code{character(1)}]\cr
A prefix for the indices.}

\item{exclude_diagonal}{[\code{logical(1)}]\cr
Exclude indices where row equals column?}
}
\value{
A \code{character} \code{vector}.
}
\description{
This function returns \code{matrix} indices as \code{character}.
}
\examples{
M <- diag(3)
matrix_indices(M)
matrix_indices(M, "M_")
matrix_indices(M, "M_", TRUE)
}
\seealso{
Other matrix helpers: 
\code{\link{check_correlation_matrix}()},
\code{\link{check_covariance_matrix}()},
\code{\link{check_transition_probability_matrix}()},
\code{\link{cov_to_chol}()},
\code{\link{diff_cov}()},
\code{\link{insert_matrix_column}()},
\code{\link{matrix_diagonal_indices}()},
\code{\link{sample_correlation_matrix}()},
\code{\link{sample_covariance_matrix}()},
\code{\link{sample_transition_probability_matrix}()},
\code{\link{stationary_distribution}()}
}
\concept{matrix helpers}
\keyword{indexing}
