% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_correlation_matrix.R
\name{sample_correlation_matrix}
\alias{sample_correlation_matrix}
\title{Sample correlation matrix}
\usage{
sample_correlation_matrix(dim, df = dim, scale = diag(dim))
}
\arguments{
\item{dim}{[\code{integer(1)}]\cr
The dimension.}

\item{df}{[\code{integer(1)}]\cr
The degrees of freedom of the inverse Wishart distribution greater or equal
\code{dim}.}

\item{scale}{[\code{matrix()}]\cr
The scale covariance matrix of the inverse Wishart distribution of dimension
\code{dim}.}
}
\value{
A correlation \code{matrix}.
}
\description{
This function samples a correlation matrix by sampling a covariance matrix
from an inverse Wishart distribution and transforming it to a correlation
matrix.
}
\examples{
sample_correlation_matrix(dim = 3)
}
\seealso{
Other matrix helpers: 
\code{\link{check_correlation_matrix}()},
\code{\link{check_covariance_matrix}()},
\code{\link{check_transition_probability_matrix}()},
\code{\link{cov_to_chol}()},
\code{\link{diff_cov}()},
\code{\link{insert_matrix_column}()},
\code{\link{matrix_diagonal_indices}()},
\code{\link{matrix_indices}()},
\code{\link{sample_covariance_matrix}()},
\code{\link{sample_transition_probability_matrix}()},
\code{\link{stationary_distribution}()}
}
\concept{matrix helpers}
\keyword{simulation}
