% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_markov_chain.R
\name{simulate_markov_chain}
\alias{simulate_markov_chain}
\title{Simulate Markov chain}
\usage{
simulate_markov_chain(Gamma, T, delta = oeli::stationary_distribution(Gamma))
}
\arguments{
\item{Gamma}{[\code{matrix()}]\cr
A transition probability matrix.}

\item{T}{[\code{integer(1)}]\cr
The length of the Markov chain.}

\item{delta}{[\code{numeric()}]\cr
A probability vector, the initial distribution.

By default, \code{delta} is the stationary distribution of \code{Gamma}.}
}
\value{
A \code{numeric} vector of length \code{T} with states.
}
\description{
This function simulates a Markov chain.
}
\examples{
Gamma <- sample_transition_probability_matrix(dim = 3)
simulate_markov_chain(Gamma = Gamma, T = 10)
}
\seealso{
Other simulation helpers: 
\code{\link{correlated_regressors}()},
\code{\link{ddirichlet_cpp}()},
\code{\link{dmvnorm_cpp}()},
\code{\link{dtnorm_cpp}()},
\code{\link{dwishart_cpp}()}
}
\concept{simulation helpers}
\keyword{simulation}
