% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_block_objects.R
\name{block_caption}
\alias{block_caption}
\title{Caption block}
\usage{
block_caption(label, style, autonum = NULL)
}
\arguments{
\item{label}{a scalar character representing label to display}

\item{style}{paragraph style name}

\item{autonum}{an object generated with function \link{run_autonum}}
}
\description{
Create a representation of a
caption that can be used for cross reference.
}
\examples{

library(officer)

run_num <- run_autonum(seq_id = "tab", pre_label = "tab. ",
  bkm = "mtcars_table")
caption <- block_caption("mtcars table",
  style = "Normal",
  autonum = run_num
)

doc_1 <- read_docx()
doc_1 <- body_add(doc_1, "A title", style = "heading 1")
doc_1 <- body_add(doc_1, "Hello world!", style = "Normal")
doc_1 <- body_add(doc_1, caption)
doc_1 <- body_add(doc_1, mtcars, style = "table_template")

print(doc_1, target = tempfile(fileext = ".docx"))
}
\seealso{
Other block functions for reporting: 
\code{\link{block_list}()},
\code{\link{block_pour_docx}()},
\code{\link{block_section}()},
\code{\link{block_table}()},
\code{\link{block_toc}()},
\code{\link{fpar}()},
\code{\link{plot_instr}()},
\code{\link{unordered_list}()}
}
\concept{block functions for reporting}
