% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add_chunk.R
\name{slip_in_seqfield}
\alias{slip_in_seqfield}
\title{append seq field}
\usage{
slip_in_seqfield(x, str, style = NULL, pos = "after")
}
\arguments{
\item{x}{an rdocx object}

\item{str}{seq field value}

\item{style}{text style}

\item{pos}{where to add the new element relative to the cursor,
"after" or "before".}
}
\description{
append seq field into a paragraph of an rdocx object.
This feature is only available when document are edited with Word,
when edited with Libre Office or another program, seq field will not
be calculated and not displayed.
}
\note{
This function will be deprecated in a next release because it is not
efficient and make users write complex code. Use instead \code{\link[=fpar]{fpar()}} to build
formatted paragraphs.
}
\examples{
x <- read_docx()
x <- body_add_par(x, "Time is: ", style = "Normal")
x <- slip_in_seqfield(x,
    str = "TIME \u005C@ \"HH:mm:ss\" \u005C* MERGEFORMAT",
    style = 'strong')

x <- body_add_par(x, " - This is a figure title", style = "centered")
x <- slip_in_seqfield(x, str = "SEQ Figure \u005C* roman",
    style = 'Default Paragraph Font', pos = "before")
x <- slip_in_text(x, "Figure: ", style = "strong", pos = "before")

x <- body_add_par(x, " - This is another figure title", style = "centered")
x <- slip_in_seqfield(x, str = "SEQ Figure \u005C* roman",
    style = 'strong', pos = "before")
x <- slip_in_text(x, "Figure: ", style = "strong", pos = "before")
x <- body_add_par(x, "This is a symbol: ", style = "Normal")
x <- slip_in_text(x, str = "SYMBOL 100 \u005Cf Wingdings",
    style = 'strong')

print(x, target = tempfile(fileext = ".docx"))
}
