% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_footnotes.R
\name{slip_in_footnote}
\alias{slip_in_footnote}
\title{append a footnote}
\usage{
slip_in_footnote(x, style = NULL, blocks, pos = "after")
}
\arguments{
\item{x}{an rdocx object}

\item{style}{text style to be used for the reference note}

\item{blocks}{set of blocks to be used as footnote content returned by
function \code{\link{block_list}}.}

\item{pos}{where to add the new element relative to the cursor, "after" or
"before".}
}
\description{
append a new footnote into a paragraph of an rdocx object
}
\examples{
library(magrittr)

img.file <- file.path( R.home("doc"), "html", "logo.jpg" )
bl <- block_list(
  fpar(ftext("hello", shortcuts$fp_bold())),
  fpar(
    ftext("hello", shortcuts$fp_bold()),
    stext(" world", "strong"),
    external_img(src = img.file, height = 1.06, width = 1.39)
  )
)

x <- read_docx() \%>\%
  body_add_par("Hello ", style = "Normal") \%>\%
  slip_in_text("world", style = "strong") \%>\%
  slip_in_footnote(style = "reference_id", blocks = bl)

print(x, target = tempfile(fileext = ".docx"))
}
