% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_docx.R
\name{read_docx}
\alias{read_docx}
\alias{print.rdocx}
\title{open a connection to a 'Word' file}
\usage{
read_docx(path = NULL)

\method{print}{rdocx}(x, target = NULL, ...)
}
\arguments{
\item{path}{path to the docx file to use as base document.}

\item{x}{an rdocx object}

\item{target}{path to the docx file to write}

\item{...}{unused}
}
\description{
read and import a docx file as an R object
representing the document.
}
\examples{
# create an rdocx object with default template ---
read_docx()

print(read_docx())
# write a rdocx object in a docx file ----
if( require(magrittr) ){
  read_docx() \%>\% print(target = tempfile(fileext = ".docx"))
}

}
\seealso{
\link{print.rdocx}, \link{body_add}
}
