% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_table}
\alias{body_add_table}
\title{add table}
\usage{
body_add_table(
  x,
  value,
  style = NULL,
  pos = "after",
  header = TRUE,
  first_row = TRUE,
  first_column = FALSE,
  last_row = FALSE,
  last_column = FALSE,
  no_hband = FALSE,
  no_vband = TRUE
)
}
\arguments{
\item{x}{a docx device}

\item{value}{a data.frame to add as a table}

\item{style}{table style}

\item{pos}{where to add the new element relative to the cursor,
one of after", "before", "on".}

\item{header}{display header if TRUE}

\item{first_row}{Specifies that the first column conditional formatting should be
applied. Details for this and other conditional formatting options can be found
at http://officeopenxml.com/WPtblLook.php.}

\item{first_column}{Specifies that the first column conditional formatting should
be applied.}

\item{last_row}{Specifies that the first column conditional formatting should be applied.}

\item{last_column}{Specifies that the first column conditional formatting should be
applied.}

\item{no_hband}{Specifies that the first column conditional formatting should be applied.}

\item{no_vband}{Specifies that the first column conditional formatting should be applied.}
}
\description{
add a table into an rdocx object
}
\examples{
library(magrittr)

doc <- read_docx() \%>\%
  body_add_table(iris, style = "table_template")

print(doc, target = tempfile(fileext = ".docx") )
}
\seealso{
Other functions for adding content: 
\code{\link{body_add_blocks}()},
\code{\link{body_add_break}()},
\code{\link{body_add_docx}()},
\code{\link{body_add_fpar}()},
\code{\link{body_add_gg}()},
\code{\link{body_add_img}()},
\code{\link{body_add_par}()},
\code{\link{body_add_toc}()}
}
\concept{functions for adding content}
