% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_comments.R
\name{docx_comments}
\alias{docx_comments}
\title{Get comments in a Word document as a data.frame}
\usage{
docx_comments(x)
}
\arguments{
\item{x}{an rdocx object}
}
\description{
return a data.frame representing the comments in a Word document.
}
\examples{
bl <- block_list(
  fpar("Comment multiple words."),
  fpar("Second line")
)

a_par <- fpar(
  "This paragraph contains",
  run_comment(
  cmt = bl,
    run = ftext("a comment."),
    author = "Author Me",
    date = "2023-06-01"
  )
)

doc <- read_docx()
doc <- body_add_fpar(doc, value = a_par, style = "Normal")

docx_file <- print(doc, target = tempfile(fileext = ".docx"))

docx_comments(read_docx(docx_file))
}
