% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_toc}
\alias{body_add_toc}
\title{Add table of content in a 'Word' document}
\usage{
body_add_toc(x, level = 3, pos = "after", style = NULL, separator = ";")
}
\arguments{
\item{x}{an rdocx object}

\item{level}{max title level of the table}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}

\item{style}{optional. style in the document that will be used to build entries of the TOC.}

\item{separator}{optional. Some configurations need "," (i.e. from Canada) separator instead of ";"}
}
\description{
Add a table of content into an rdocx object.
The TOC will be generated by Word, if the document is not
edited with Word (i.e. Libre Office) the TOC will not be generated.
}
\examples{
doc <- read_docx()
doc <- body_add_toc(doc)

print(doc, target = tempfile(fileext = ".docx"))
}
\seealso{
Other functions for adding content: 
\code{\link{body_add_blocks}()},
\code{\link{body_add_break}()},
\code{\link{body_add_caption}()},
\code{\link{body_add_docx}()},
\code{\link{body_add_fpar}()},
\code{\link{body_add_gg}()},
\code{\link{body_add_img}()},
\code{\link{body_add_par}()},
\code{\link{body_add_plot}()},
\code{\link{body_add_table}()},
\code{\link{body_append_start_context}()}
}
\concept{functions for adding content}
