% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_spectro.R
\name{label_spectro}
\alias{label_spectro}
\title{Plot a labeled spectrogram}
\usage{
label_spectro(wave, reference = NULL, detection = NULL,
 envelope = FALSE, threshold = NULL, smooth = 5, collevels = seq(-100, 0, 5),
 palette = viridis::viridis, template.correlation = NULL,
 line.x.position = 2, hop.size = NULL, ...)
}
\arguments{
\item{wave}{A 'wave' class object.}

\item{reference}{Data frame or 'selection.table' (following the warbleR package format) with the reference selections (start and end of the sound events). Must contained at least the following columns: "sound.files", "selec", "start" and "end".}

\item{detection}{Data frame or 'selection.table' with the detection (start and end of the sound events) Must contained at least the following columns: "sound.files", "selec", "start" and "end".}

\item{envelope}{Logical to control whether the amplitude envelope is plotted. Default is \code{FALSE}.}

\item{threshold}{A numeric vector on length 1 indicated the amplitude or correlation threshold to plot on the envelope or correlation scores respectively. Default is \code{NULL}.}

\item{smooth}{A numeric vector of length 1 to smooth the amplitude envelope
with a sum smooth function. It controls the time range (in ms) in which amplitude samples are smoothed (i.e. averaged with neighboring samples). Default is 5. 0 means no smoothing is applied.}

\item{collevels}{Numeric sequence of negative numbers to control color partitioning and amplitude values that are shown (as in \code{\link[seewave]{spectro}}).}

\item{palette}{Function with the color palette to be used on the spectrogram (as in \code{\link[seewave]{spectro}})}

\item{template.correlation}{List extracted from the output of \code{\link{template_correlator}} containing the correlation scores and metadata for an specific sound file/template dyad. For instance 'correlations[[1]]' where 'correlations' is the output of a \code{\link{template_correlator}} call. If supplied the correlation is also plotted. Default is \code{NULL}.}

\item{line.x.position}{Numeric vector of length 1 with the position in the frequency axis (so in kHz) of the lines highlighting sound events. Default is 2.}

\item{hop.size}{A numeric vector of length 1 specifying the time window duration (in ms). Default is 11.6 ms, which is equivalent to 512 'wl' for a 44.1 kHz sampling rate.}

\item{...}{Additional arguments to be passed to  \code{\link[seewave]{spectro}} for further spectrogram customization.}
}
\value{
A spectrogram along with lines highlighting the position of sound events in 'reference' and/or 'detection'. If supplied it will also plot the amplitude envelope or corelation scores below the spectroram.
}
\description{
\code{label_spectro} plot a spectrogram along with amplitude envelopes or cross-corelation scores
}
\details{
This function plots spectrograms annotated with the position of sound events. \strong{Created for graphs included in the vignette, and probably only useful for that or for very short recordings}. Only works on a single 'wave' object at the time.
}
\examples{
{
# load example data
data(list = "lbh1", "lbh_reference")

# adding labels
label_spectro(wave = lbh1,
reference = lbh_reference[lbh_reference$sound.files == "lbh1.wav", ],
wl = 200, ovlp = 50, flim = c(1, 10))

# adding envelope
label_spectro(wave = lbh1,
detection = lbh_reference[lbh_reference$sound.files == "lbh1.wav", ],
wl = 200, ovlp = 50, flim = c(1, 10))

# see the package vignette for more examples
}

}
\references{
{
#' Araya-Salas, M. (2021), ohun: diagnosing and optimizing automated sound event detection. R package version 0.1.0.
}
}
\seealso{
\code{\link{energy_detector}}, \code{\link{template_correlator}}, \code{\link{template_detector}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr}).
}
