% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oiixtab.R
\name{oii.xtab}
\alias{oii.xtab}
\title{A cross-tabulation with measures of association}
\usage{
oii.xtab(r, c = NULL, s = NULL, row = FALSE, col = FALSE,
  pctcell = FALSE, stats = FALSE, rescell = FALSE, chistd = FALSE,
  expcell = FALSE, chicell = FALSE, warnings = FALSE, varnames = NULL,
  ...)
}
\arguments{
\item{r}{the row variable. If \code{r} is a \code{\link{table}}, \code{\link{data.frame}}, or \code{\link{matrix}}, then \code{c} and \code{s} are ignored.}

\item{c}{the column variable.}

\item{s}{the split variable. The \code{r} and \code{c} will be separately tabulated for each unique value of \code{s}.}

\item{row}{Show row percentages? Defaults to FALSE.}

\item{col}{Show column percentages? Defaults to FALSE.}

\item{pctcell}{Print cell percentages? Defaults to FALSE.}

\item{stats}{Print measures of association? Defaults to FALSE. This parameter is ignored either \code{r} or \code{c} has only one value. See \code{\link{association.measures}}.}

\item{rescell}{Print residual cell count under the null hypothesis?  Defaults to FALSE.}

\item{chistd}{Print cell standardized residuals to pearson chi-square? Defaults to FALSE.}

\item{expcell}{Print expected cell count under the null hypothesis? Defaults to FALSE.}

\item{chicell}{Print cell contribution to pearson chi-square? Defaults to FALSE.}

\item{warnings}{a logical value indicating whether warnings should be shown (defaults to FALSE, no warnings).}

\item{varnames}{Names used to refer to \code{r}, \code{c}, and \code{s} in the printed output.}

\item{...}{Additional parameters to be passed to \code{\link[gmodels]{CrossTable}}.}
}
\description{
This function prints a 2-way table with optional cell statistics 
and measures of association
}
\examples{
#Create var1 as 200 A's, B's, and C's
var1<-sample(LETTERS[1:3],size=200,replace=TRUE)
#Create var2 as 200 numbers in the range 1 to 4
var2<-sample(1:4,size=200,replace=TRUE)

#Print a simple 2-way table of var1 and var2
oii.xtab(var1,var2)

#Print the row and column percents
oii.xtab(var1,var2,row=TRUE,col=TRUE)

#Print measures of association statistics
oii.xtab(var1,var2,stats=TRUE)

#If the variables are part of a data.frame
my.data.frame<-data.frame(var1,var2)
#We can use the $ to get the variables
oii.xtab(my.data.frame$var1,my.data.frame$var2)
#or use the with(...) command to save some typing
with(my.data.frame,oii.xtab(var1,var2))

#Three-way tables are also possible
#Create var3 as 200 "I"'s, "II"'s, and "III"'s
var3<-sample(c("I","II","III"),size=200,replace=TRUE)
oii.xtab(var1,var2,var3)

#We can also pass in a data.frame directly as the first argument
my.data.frame<-data.frame(var1,var2,var3)
oii.xtab(my.data.frame,stats=TRUE)
#The variables in the data.frame are used in order;
#so, sometimes it is useful to re-order them. For example,
oii.xtab(my.data.frame[,c("var3","var1","var2")],stats=TRUE)
#Of course, it is also possible to pass in the variables one 
#at a time or use with(...) as shown above.

}
\seealso{
\code{\link{association.measures}}, \code{\link[gmodels]{CrossTable}}, \code{\link[Deducer]{likelihood.test}}, \code{\link[rapportools]{lambda.test}}
}

