% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-residual-vs-regressor-plot.R
\name{ols_plot_resid_regressor}
\alias{ols_plot_resid_regressor}
\alias{ols_rvsr_plot}
\title{Residual vs regressor plot}
\usage{
ols_plot_resid_regressor(model, variable, print_plot = TRUE)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{variable}{New predictor to be added to the \code{model}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\description{
Graph to determine whether we should add a new predictor to the model already
containing other predictors. The residuals from the model is regressed on the
new predictor and if the plot shows non random pattern, you should consider
adding the new predictor to the model.
}
\section{Deprecated Function}{

\code{ols_rvsr_plot()} has been deprecated. Instead use \code{ols_plot_resid_regressor()}.
}

\examples{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_plot_resid_regressor(model, 'drat')

}
\seealso{
[ols_plot_added_variable()], [ols_plot_comp_plus_resid()]
}
