% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which.pmax.r
\name{which.pmax}
\alias{which.pmax}
\alias{which.pmin}
\title{Which vector has maximum value at each element}
\usage{
which.pmax(..., na.rm = TRUE)

which.pmin(..., na.rm = TRUE)
}
\arguments{
\item{...}{Two or more vectors. If lengths do not match, the results will likely be be unanticipated.}

\item{na.rm}{Logical, if \code{FALSE} and any of the vectors contains an \code{NA} or \code{NaN}, the function will return an \code{NA}. If \code{TRUE} (default), then \code{NA} will only be returned if all elements at that position are \code{NA} or \code{NaN}.}
}
\value{
Vector the same length as the input, with numeric values indicating which vector has the highest value at that position. In case of ties, the index of the first vector is returned.
}
\description{
These functions are vectorized versions of \code{which.max} and \code{which.min}, which return the index of the value that is maximum or minimum (or the first maximum/minimum value, if there is a tie). In this case, the function is supplied two or more vectors of the same length. For each element at the same position (e.g., the first element in each vector, then the second element, etc.) the function returns an integer indicating which vector has the highest or lowest value (or the index of the first vector with the highest or lowest value in case of ties).
}
\section{Functions}{
\itemize{
\item \code{which.pmin()}: Which vector has minimum value at each element

}}
\examples{
set.seed(123)
a <- sample(9, 5)
b <- sample(9, 5)
c <- sample(9, 5)
a[2:3] <- NA
b[3] <- NA
a[6] <- NA
b[6] <- NA
c[6] <- NA
which.pmax(a, b, c)
which.pmin(a, b, c)
which.pmax(a, b, c, na.rm=FALSE)
which.pmin(a, b, c, na.rm=FALSE)
}
\seealso{
\code{\link{which.max}}, \code{\link{which.min}}, \code{\link{pmax}}, \code{\link{pmin}}
}
