% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.cdm_reference}
\alias{summary.cdm_reference}
\title{Summary a cdm reference}
\usage{
\method{summary}{cdm_reference}(object, ...)
}
\arguments{
\item{object}{A cdm reference object.}

\item{...}{For compatibility (not used).}
}
\value{
A summarised_result object with a summary of the data contained in
the cdm.
}
\description{
Summary a cdm reference
}
\examples{
library(dplyr, warn.conflicts = FALSE)

person <- tibble(
  person_id = 1, gender_concept_id = 0, year_of_birth = 1990,
  race_concept_id = 0, ethnicity_concept_id = 0
)
observation_period <- tibble(
  observation_period_id = 1, person_id = 1,
  observation_period_start_date = as.Date("2000-01-01"),
  observation_period_end_date = as.Date("2023-12-31"),
  period_type_concept_id = 0
)
cdm <- cdmFromTables(
  tables = list("person" = person, "observation_period" = observation_period),
  cdmName = "test"
)

summary(cdm)

}
