% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filterGroup}
\alias{filterGroup}
\title{Filter the group_name-group_level pair in a summarised_result}
\usage{
filterGroup(result, ...)
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{...}{Expressions that return a logical value (\code{groupColumns()} are
used to evaluate the expression), and are defined in terms of the variables
in .data. If multiple expressions are included, they are combined with the &
operator. Only rows for which all conditions evaluate to TRUE are kept.}
}
\value{
A \verb{<summarised_result>} object with only the rows that fulfill the
required specified group.
}
\description{
Filter the group_name-group_level pair in a summarised_result
}
\examples{
library(dplyr)
library(omopgenerics)

x <- tibble(
  "result_id" = 1L,
  "cdm_name" = "eunomia",
  "group_name" = c("cohort_name", "age_group &&& cohort_name", "age_group"),
  "group_level" = c("my_cohort", ">40 &&& second_cohort", "<40"),
  "strata_name" = "sex",
  "strata_level" = "Female",
  "variable_name" = "number subjects",
  "variable_level" = NA_character_,
  "estimate_name" = "count",
  "estimate_type" = "integer",
  "estimate_value" = c("100", "44", "14"),
  "additional_name" = "overall",
  "additional_level" = "overall"
) |>
  newSummarisedResult()

x |>
  filterGroup(cohort_name == "second_cohort")

}
