% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodAttrition.R
\name{attrition.cohort_table}
\alias{attrition.cohort_table}
\title{Get cohort attrition from a cohort_table object.}
\usage{
\method{attrition}{cohort_table}(x)
}
\arguments{
\item{x}{A cohort_table}
}
\value{
A table with the attrition.
}
\description{
Get cohort attrition from a cohort_table object.
}
\examples{
 \donttest{
library(omopgenerics)
library(dplyr, warn.conflicts = FALSE)

person <- tibble(
  person_id = 1, gender_concept_id = 0, year_of_birth = 1990,
  race_concept_id = 0, ethnicity_concept_id = 0
)
observation_period <- tibble(
  observation_period_id = 1, person_id = 1,
  observation_period_start_date = as.Date("2000-01-01"),
  observation_period_end_date = as.Date("2023-12-31"),
  period_type_concept_id = 0
)
cohort <- tibble(
  cohort_definition_id = c(1, 1, 1, 2),
  subject_id = 1,
  cohort_start_date = as.Date(c("2020-01-01", "2021-01-01", "2022-01-01", "2022-01-01")),
  cohort_end_date = as.Date(c("2020-01-01", "2021-01-01", "2022-01-01", "2022-01-01")),
)
cdm <- cdmFromTables(
  tables = list("person" = person, "observation_period" = observation_period),
  cdmName = "my_example_cdm",
  cohortTables = list("cohort1" = cohort)
)

attrition(cdm$cohort1)
}
}
