% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solution-api.R
\name{new_solution}
\alias{new_solution}
\title{Create a new solution}
\usage{
new_solution(
  model,
  objective_value,
  status,
  solution,
  solution_column_duals = function() NA_real_,
  solution_row_duals = function() NA_real_,
  additional_solver_output = list()
)
}
\arguments{
\item{model}{the optimization model that was solved}

\item{objective_value}{a numeric objective value}

\item{status}{the status of the solution}

\item{solution}{a named numeric vector containing the primal solution values}

\item{solution_column_duals}{A function without arguments that returns a numeric vector containing the column dual solution values. `NA_real_`, if no column duals are available/defined.}

\item{solution_row_duals}{A function without arguments that returns a numeric vector containing the column dual solution values. `NA_real_`, if no column duals are available/defined.}

\item{additional_solver_output}{A named list of additional solver information}
}
\description{
This function/class should only be used if you develop your own solver.
}
