% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{read_selected_omx}
\alias{read_selected_omx}
\title{Read a OMX matrix based on a lookup vector}
\usage{
read_selected_omx(
  file,
  matrix_name,
  row_selection = NULL,
  col_selection = NULL,
  row_labels = NULL,
  col_labels = NULL
)
}
\arguments{
\item{file}{Path name of the OMX file where the lookup resides.}

\item{matrix_name}{Name of the matrix in the OMX file.}

\item{row_selection}{Row selection statement or vector of row selection
statements (see Details).}

\item{col_selection}{Column selection statement or vector of column selection
statements (see Details).}

\item{row_labels}{Name of lookup to use for labeling rows.}

\item{col_labels}{Name of lookup to use for labeling columns}
}
\value{
An R matrix object representing the selected rows and colums.
}
\description{
This function reads a portion of an OMX matrix using selection statements to
define the portion.
}
\details{
Multiple selection selection statements can be used for
each dimension. Each selection statement is a logical expression represented
in a double-quoted string. The left operand is the name of a lookup vector
The operator can be any logical operator including %in% The right operand is
the value or values to check against. This can be the name of a vector
defined in the calling environment. If the right operand contains literal
string values, those values must be single-quoted. Multiple selection
conditions may be used as argument by including in a vector. Multiple
selection conditions are treated as intersections.
}
\examples{
omxfile <- omxr_example("skims.omx")
read_selected_omx(
  omxfile, "DIST", row_selection = 'EI == "Ext"' 
)

}
