% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_sample_to_tibble.R
\name{parameter_sample_to_tibble}
\alias{parameter_sample_to_tibble}
\title{Convert parameter sample to data table}
\usage{
parameter_sample_to_tibble(model, sample, ...)
}
\arguments{
\item{model}{an object of class \link{srpmodel} containing prior information}

\item{sample}{a stanfit object with samples from the respective model.}

\item{...}{further arguments passed to method implementations}
}
\value{
a tibble with the sampled parameters, in long format
}
\description{
\code{parameter_sample_to_tibble()} takes a \link[rstan:stanfit-class]{rstan::stanfit} parameter sample of
a model, extracts the paramters values and returns them in a data frame.
}
\examples{
mdl <- create_srpmodel(A = define_srp_prior())
smpl <- sample_prior(mdl, seed = 3647L)
parameter_sample_to_tibble(mdl, smpl)

}
\seealso{
\code{\link[=sample_prior]{sample_prior()}} \code{\link[=sample_posterior]{sample_posterior()}}
}
