% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srpmodel.R
\name{srpmodel}
\alias{srpmodel}
\alias{srp-model}
\alias{define_srp_prior}
\alias{create_srpmodel}
\title{A stable-response-progression model}
\usage{
define_srp_prior(
  p_mean = 0.5,
  p_n = 3,
  p_eta = 0,
  p_min = 0,
  p_max = 1,
  median_t_q05 = c(1, 1, 1),
  median_t_q95 = c(60, 60, 60),
  shape_q05 = rep(0.9, 3),
  shape_q95 = rep(2.5, 3),
  visit_spacing = 1,
  recruitment_rate = 1
)

create_srpmodel(
  ...,
  maximal_time = 10 * 12,
  states = c("stable", "response", "progression"),
  censored = "EOF"
)
}
\arguments{
\item{p_mean}{numeric, mean of the beta prior for the response probability}

\item{p_n}{numeric, beta prior equivalent sample size (a + b)}

\item{p_eta}{numeric, robustification parameter for beta prior; actual
prior is (1 - eta) beta + eta; i.e., eta is the non-informative weight.}

\item{p_min}{numeric, minimal response probability}

\item{p_max}{numeric, maximal response probability}

\item{median_t_q05}{numeric of length three,
5\% quantiles of the log-normal distributions for the
median time-to-next-event for the three transitions s->r, s->p, r->p.}

\item{median_t_q95}{numeric of length three,
95\% quantiles of the log-normal distributions for the
median time-to-next-event for the three transitions s->r, s->p, r->p.}

\item{shape_q05}{numeric of length three,
5\% quantiles of the log-normal distributions for the shapes of the
time-to-next-event distributions for the three transitions s->r, s->p, r->p.}

\item{shape_q95}{numeric of length three,
95\% quantiles of the log-normal distributions for the shapes of the
time-to-next-event distributions for the three transitions s->r, s->p, r->p.}

\item{visit_spacing}{numeric, fixed duration between visits}

\item{recruitment_rate}{numeric, constant recruitment rate}

\item{...}{named \code{srp_prior} objects; the argument names serve as
group labels}

\item{maximal_time}{the maximal overall runtime of the trial as measured from
the first visit of any group. No visits past this point are sampled.}

\item{states}{character vector of three states (initial, intermediate,
terminal)}

\item{censored}{string, indicator of premature censoring events;
no data is imputed after this point.}
}
\value{
\code{define_srp_prior()} returns an object of class \code{srp_prior},
all inputs are accessible via
\verb{$x} where \code{x} is the name of the input argument in the function call except
for the two parameters \code{visit_spacing} and \code{recruitment_rate}.
These two parameters are saved as attributes
and can be retrieved directly using \code{attr(mdl, "visit_spacing")} and
\code{attr(mdl, "recruitment_rate")}.

\code{create_srpmodel()} returns an object of class \code{c("srpmodel", "list")} that
holds information about potentially multiple groups in a compact format and
can be accessed using the list operator \verb{$name}.
\code{group_id} is a character vector with the group names,
\code{maximal_time} is the maximal follow-up time since the first visit in the
study, \code{visit_spacing} is the vector of per-group difference between visits
(only relevant for forward sampling), \code{recruitment_rate} is the vector of
per-group recruitment rates, \code{stan_model} is the pre-compiled 'stan' model
used for inference, \code{states} is the vector of state names in the multi-state
model, and \code{prior} is a list of hyperparamters for the model prior with
elements \code{p}, vector, for the response probability per group,
\code{median_t} is an \code{c(n_groups, 3, 2)} dimensional array where
\code{median_t[i,j,1]}
holds the 5\% quantile of the the lognormal prior on median transition time
for group \code{i} and transition \code{j} and \code{median_t[i,j,2]} the corresponding
upper 95\% quantile. The \code{shape} hyperparamter has the same format and
specified the corresponding quantiles for the Weibull shape parameter.
}
\description{
\code{create_model()} takes one or more prior-specifications for an
SRP multi-state model and combines them into a single model object.
Groups are still treated as independent.
}
\details{
\code{define_srp_prior()} specifies a prior distribution for a
three state model (stable, response, progression) for
a single group.
}
\examples{
# a model with prior 25\% response rate and variance equivalent to
# 10 data points (i.e. a Beta(2.5, 7.5) distribution).
grp <- define_srp_prior(p_mean = 0.25, p_n = 10)
attr(grp, "recruitment_rate")

# a model with two groups and different priors on the respective response
# probabilities
mdl <- create_srpmodel(
  A = define_srp_prior(),
  B = define_srp_prior(p_mean = 0.33, p_n = 10)
)
mdl$median_t

}
