% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.env_summarized.R
\name{print.env_summarized}
\alias{print.env_summarized}
\title{print.env_summarized}
\usage{
\method{print}{env_summarized}(x, return_area = FALSE, digits = 2, ...)
}
\arguments{
\item{x}{Random patterns.}

\item{return_area}{If true, not the ratio but the area is returned.}

\item{digits}{Number of decimal places (round).}

\item{...}{Arguments passed to cat}
}
\value{
No return value
}
\description{
Print method for env_summarized object
}
\details{
Printing method for summarized envelope created with \code{\link{summarize_envelope}}.
}
\examples{
set.seed(42)
input_pattern <- spatstat.core::rThomas(kappa = 15, scale = 0.05, mu = 5)

cluster_env <- spatstat.core::envelope(input_pattern, fun = "pcf", nsim = 39,
funargs = list(divisor = "d", correction = "Ripley", stoyan = 0.25))

x <- summarize_envelope(cluster_env)
print(x)

}
\seealso{
\code{\link{summarize_envelope}}
}
