% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.r
\name{dsadmin.perm}
\alias{dsadmin.perm}
\title{Get the DataSHIELD permissions}
\usage{
dsadmin.perm(opal)
}
\arguments{
\item{opal}{Opal connection object.}
}
\value{
A data.frame with columns: subject, type, permission
}
\description{
Get the permissions that were applied to the DataSHIELD service.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.perm_add(o, c('andrei', 'valentina'), 'user', 'use')
dsadmin.perm(o)
dsadmin.perm_delete(o, c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
