% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.admin.R
\name{oadmin.perm_delete}
\alias{oadmin.perm_delete}
\title{Delete a R permission}
\usage{
oadmin.perm_delete(opal, subject, type = "user")
}
\arguments{
\item{opal}{Opal connection object.}

\item{subject}{A vector of subject identifiers: user names or group names (depending on the type).}

\item{type}{The type of subject: user (default) or group.}
}
\description{
Delete a permission that was applied to the R service. Silently returns when there is no such permission.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
oadmin.perm_add(o, c('andrei', 'valentina'), 'user', 'use')
oadmin.perm(o)
oadmin.perm_delete(o, c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
