% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.assign.R
\name{opal.assign.table.tibble}
\alias{opal.assign.table.tibble}
\title{Data assignment to a tibble}
\usage{
opal.assign.table.tibble(
  opal,
  symbol,
  value,
  variables = NULL,
  missings = FALSE,
  identifiers = NULL,
  id.name = "id",
  with.factors = FALSE,
  updated.name = NULL,
  async = FALSE
)
}
\arguments{
\item{opal}{Opal object.}

\item{symbol}{Name of the R symbol.}

\item{value}{The fully qualified name of a table in Opal.}

\item{variables}{List of variable names or Javascript expression that selects the variables of a table (ignored if value does not refere to a table). See javascript documentation: http://wiki.obiba.org/display/OPALDOC/Variable+Methods}

\item{missings}{If TRUE, missing values will be pushed from Opal to R, default is FALSE.}

\item{identifiers}{Name of the identifiers mapping to use when assigning entities to R (from Opal 2.0).}

\item{id.name}{Add a vector with the given name representing the entity identifiers (from Opal 2.6). Default is 'id'.}

\item{with.factors}{If TRUE, the categorical variables will be assigned as factors (from Opal 2.14). Default is FALSE.}

\item{updated.name}{Deprecated. Add a vector with the given name representing the creation and last update timestamps (from Opal 2.6 to 2.13). Default is NULL.}

\item{async}{R script is executed asynchronously within the session (default is FALSE). If TRUE, the value returned is the ID of the command to look for (from Opal 2.1).}
}
\description{
Assign a Opal table to a tibble identified by a R symbol in the current R session.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# assign a table and make some operation on it
opal.assign.table.tibble(o, 'D', 'datashield.CNSIM1')
opal.execute(o, "class(D)")
opal.logout(o)
}
}
\seealso{
Other assignment functions: 
\code{\link{opal.assign.data}()},
\code{\link{opal.assign.resource}()},
\code{\link{opal.assign.script}()},
\code{\link{opal.assign.table}()},
\code{\link{opal.assign}()}
}
\concept{assignment functions}
