% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.resource.R
\name{opal.resource_extension_create}
\alias{opal.resource_extension_create}
\title{Create an extended resource reference in a project}
\usage{
opal.resource_extension_create(
  opal,
  project,
  name,
  provider,
  factory,
  parameters,
  description = NULL,
  credentials = NULL
)
}
\arguments{
\item{opal}{Opal object.}

\item{project}{Name of the project.}

\item{name}{Name of the resource in the project.}

\item{provider}{Name of the R package in which the resource is defined.}

\item{factory}{Name of the JS function that turns parameters and credentials into a resource object.}

\item{parameters}{A named list of the resource parameters.}

\item{description}{The description of the resource (optional).}

\item{credentials}{A named list of the resource credentials (optional).}
}
\description{
Create an extended resource reference in a project
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.resource_extension_create(o, 'RSRC', 'ga4gh_1000g',
  provider = 'dsOmics', factory = 'ga4gh-htsget',
  parameters = list(
    host = 'https://htsget.ga4gh.org',
    sample = '1000genomes.phase1.chr1',
    reference = '1',
    start = '1',
    end = '100000',
    format = 'GA4GHVCF'
  )
)
opal.logout(o)
}
}
\seealso{
Other project functions: 
\code{\link{opal.project_create}()},
\code{\link{opal.project_delete}()},
\code{\link{opal.project_exists}()},
\code{\link{opal.projects}()},
\code{\link{opal.project}()},
\code{\link{opal.resource_create}()},
\code{\link{opal.resource_exists}()},
\code{\link{opal.resource_get}()},
\code{\link{opal.resources}()},
\code{\link{opal.resource}()}
}
\concept{project functions}
