/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

public class Span
implements Comparable {
    private int start;
    private int end;

    public Span(int s, int e) {
        this.start = s;
        this.end = e;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean contains(Span s) {
        return this.start <= s.getStart() && s.getEnd() <= this.end;
    }

    public boolean intersects(Span s) {
        int sstart = s.getStart();
        return this.contains(s) || s.contains(this) || this.getStart() <= sstart && sstart < this.getEnd() || sstart <= this.getStart() && this.getStart() < s.getEnd();
    }

    public boolean crosses(Span s) {
        int sstart = s.getStart();
        return !this.contains(s) && !s.contains(this) && (this.getStart() <= sstart && sstart < this.getEnd() || sstart <= this.getStart() && this.getStart() < s.getEnd());
    }

    public int compareTo(Object o) {
        Span s = (Span)o;
        if (this.getStart() < s.getStart()) {
            return -1;
        }
        if (this.getStart() == s.getStart()) {
            if (this.getEnd() > s.getEnd()) {
                return -1;
            }
            if (this.getEnd() < s.getEnd()) {
                return 1;
            }
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        return this.start << 16 | (0xFFFF | this.end);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Span s = (Span)o;
        return this.getStart() == s.getStart() && this.getEnd() == s.getEnd();
    }

    public String toString() {
        StringBuffer toStringBuffer = new StringBuffer(15);
        return toStringBuffer.append(this.getStart()).append("..").append(this.getEnd()).toString();
    }
}

