/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileReader;
import opennlp.maxent.BasicContextGenerator;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;

public class Predict {
    MaxentModel _model;
    ContextGenerator _cg = new BasicContextGenerator();

    public Predict(MaxentModel m) {
        this._model = m;
    }

    private void eval(String predicates) {
        double[] ocs = this._model.eval(this._cg.getContext(predicates));
        System.out.println("For context: " + predicates + "\n" + this._model.getAllOutcomes(ocs) + "\n");
    }

    public static void main(String[] args) {
        String modelFileName;
        String dataFileName;
        if (args.length > 0) {
            dataFileName = args[0];
            modelFileName = args.length > 1 ? args[1] : String.valueOf(dataFileName.substring(0, dataFileName.lastIndexOf(46))) + "Model.txt";
        } else {
            dataFileName = "";
            modelFileName = "weatherModel.txt";
        }
        Predict predictor = null;
        try {
            GISModel m = new SuffixSensitiveGISModelReader(new File(modelFileName)).getModel();
            predictor = new Predict(m);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        if (dataFileName.equals("")) {
            super.eval("Rainy Happy Humid");
            predictor.eval("Rainy");
            predictor.eval("Blarmey");
        } else {
            try {
                PlainTextByLineDataStream ds = new PlainTextByLineDataStream(new FileReader(new File(args[0])));
                while (ds.hasNext()) {
                    String s = (String)ds.nextToken();
                    predictor.eval(s.substring(0, s.lastIndexOf(32)));
                }
                return;
            }
            catch (Exception e) {
                System.out.println("Unable to read from specified file: " + args[0]);
                System.out.println();
            }
        }
    }
}

