/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import opennlp.maxent.DataIndexer;
import opennlp.maxent.EventStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.GISTrainer;

public class GIS {
    public static boolean PRINT_MESSAGES = true;
    public static double SMOOTHING_OBSERVATION = 0.1;

    public static GISModel trainModel(EventStream eventStream) {
        return GIS.trainModel(eventStream, 100, 0, false, PRINT_MESSAGES);
    }

    public static GISModel trainModel(EventStream eventStream, boolean smoothing) {
        return GIS.trainModel(eventStream, 100, 0, smoothing, PRINT_MESSAGES);
    }

    public static GISModel trainModel(EventStream eventStream, int iterations, int cutoff) {
        return GIS.trainModel(eventStream, iterations, cutoff, false, PRINT_MESSAGES);
    }

    public static GISModel trainModel(EventStream eventStream, int iterations, int cutoff, boolean smoothing, boolean printMessagesWhileTraining) {
        GISTrainer trainer = new GISTrainer(printMessagesWhileTraining);
        trainer.setSmoothing(smoothing);
        trainer.setSmoothingObservation(SMOOTHING_OBSERVATION);
        return trainer.trainModel(eventStream, iterations, cutoff);
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer, boolean smoothing) {
        return GIS.trainModel(iterations, indexer, false, smoothing);
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer, boolean printMessagesWhileTraining, boolean smoothing) {
        GISTrainer trainer = new GISTrainer(printMessagesWhileTraining);
        trainer.setSmoothing(smoothing);
        trainer.setSmoothingObservation(SMOOTHING_OBSERVATION);
        return trainer.trainModel(iterations, indexer);
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer) {
        return GIS.trainModel(iterations, indexer, true, false);
    }
}

