/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.getopt.Getopt;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import opennlp.maxent.Evalable;
import opennlp.maxent.Event;
import opennlp.maxent.EventCollectorAsStream;
import opennlp.maxent.EventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class TrainEval {
    public static void eval(MaxentModel model, Reader r, Evalable e) {
        TrainEval.eval(model, r, e, false);
    }

    public static void eval(MaxentModel model, Reader r, Evalable e, boolean verbose) {
        float totPos = 0.0f;
        float truePos = 0.0f;
        float falsePos = 0.0f;
        Event[] events = e.getEventCollector(r).getEvents(true);
        String negOutcome = e.getNegativeOutcome();
        int i = 0;
        while (i < events.length) {
            String guess = model.getBestOutcome(model.eval(events[i].getContext()));
            String ans = events[i].getOutcome();
            if (verbose) {
                System.out.println(String.valueOf(ans) + " " + guess);
            }
            if (!ans.equals(negOutcome)) {
                totPos += 1.0f;
            }
            if (!guess.equals(negOutcome) && !guess.equals(ans)) {
                falsePos += 1.0f;
            } else if (ans.equals(guess)) {
                truePos += 1.0f;
            }
            ++i;
        }
        System.out.println("Precision: " + truePos / (truePos + falsePos));
        System.out.println("Recall:    " + truePos / totPos);
    }

    public static MaxentModel train(EventStream events, int cutoff) {
        return GIS.trainModel(events, 100, cutoff);
    }

    public static void run(String[] args, Evalable e) throws IOException {
        int c;
        String dir = "./";
        String stem = "maxent";
        int cutoff = 0;
        boolean train = false;
        boolean verbose = false;
        boolean local = false;
        Getopt g = new Getopt("maxent", args, "d:s:c:tvl");
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 100: {
                    dir = String.valueOf(g.getOptarg()) + "/";
                    break;
                }
                case 115: {
                    stem = g.getOptarg();
                    break;
                }
                case 99: {
                    cutoff = Integer.parseInt(g.getOptarg());
                    break;
                }
                case 116: {
                    train = true;
                    break;
                }
                case 108: {
                    local = true;
                    break;
                }
                case 118: {
                    verbose = true;
                }
            }
        }
        int lastIndex = g.getOptind();
        if (lastIndex >= args.length) {
            System.out.println("This is a usage message from opennlp.maxent.TrainEval. You have called the training procedure for a maxent application with the incorrect arguments.  These are the options:");
            System.out.println("\nOptions for defining the model location and name:");
            System.out.println(" -d <directoryName>");
            System.out.println("\tThe directory in which to store the model.");
            System.out.println(" -s <modelName>");
            System.out.println("\tThe name of the model, e.g. EnglishPOS.bin.gz or NameFinder.txt.");
            System.out.println("\nOptions for training:");
            System.out.println(" -c <cutoff>");
            System.out.println("\tAn integer cutoff level to reduce infrequent contextual predicates.");
            System.out.println(" -t\tTrain a model. If absent, the given model will be loaded and evaluated.");
            System.out.println("\nOptions for evaluation:");
            System.out.println(" -l\t the evaluation method of class that uses the model. If absent, TrainEval's eval method is used.");
            System.out.println(" -v\t verbose.");
            System.out.println("\nThe final argument is the data file to be loaded and used for either training or evaluation.");
            System.out.println("\nAs an example for training:\n java opennlp.grok.preprocess.postag.POSTaggerME -t -d ./ -s EnglishPOS.bin.gz -c 7 postag.data");
            System.exit(0);
        }
        FileReader datafr = new FileReader(args[lastIndex]);
        if (train) {
            MaxentModel m = TrainEval.train(new EventCollectorAsStream(e.getEventCollector(datafr)), cutoff);
            new SuffixSensitiveGISModelWriter((GISModel)m, new File(String.valueOf(dir) + stem)).persist();
        } else {
            GISModel model = new SuffixSensitiveGISModelReader(new File(String.valueOf(dir) + stem)).getModel();
            if (local) {
                e.localEval(model, datafr, e, verbose);
            } else {
                TrainEval.eval(model, datafr, e, verbose);
            }
        }
    }
}

