/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import opennlp.model.TrainUtil;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.BaseModel;
import org.apache.uima.resource.ResourceInitializationException;

public final class OpennlpUtil {
    private OpennlpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(BaseModel model, File modelFile) throws IOException {
        OutputStream modelOut = null;
        try {
            modelOut = new BufferedOutputStream(new FileOutputStream(modelFile));
            model.serialize(modelOut);
        }
        finally {
            if (modelOut != null) {
                modelOut.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] loadBytes(File inFile) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        FileInputStream in = null;
        try {
            int len;
            in = new FileInputStream(inFile);
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                bytes.write(buffer, 0, len);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return bytes.toByteArray();
    }

    public static final TrainingParameters loadTrainingParams(String inFileValue, boolean isSequenceTrainingAllowed) throws ResourceInitializationException {
        TrainingParameters params;
        if (inFileValue != null) {
            InputStream paramsIn = null;
            try {
                paramsIn = new FileInputStream(new File(inFileValue));
                params = new TrainingParameters(paramsIn);
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            finally {
                try {
                    if (paramsIn != null) {
                        paramsIn.close();
                    }
                }
                catch (IOException e) {}
            }
            if (!TrainUtil.isValid((Map)params.getSettings())) {
                throw new ResourceInitializationException((Throwable)new Exception("Training parameters file is invalid!"));
            }
            if (!isSequenceTrainingAllowed && TrainUtil.isSequenceTraining((Map)params.getSettings())) {
                throw new ResourceInitializationException((Throwable)new Exception("Sequence training is not supported!"));
            }
        } else {
            params = TrainingParameters.defaultParams();
        }
        return params;
    }
}

