% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_chat_completion.R
\name{create_chat_completion}
\alias{create_chat_completion}
\title{Create chat completion}
\usage{
create_chat_completion(
  model = c("gpt-3.5-turbo", "gpt-3.5-turbo-0301"),
  messages = NULL,
  temperature = 1,
  top_p = 1,
  n = 1,
  stream = FALSE,
  stop = NULL,
  max_tokens = NULL,
  presence_penalty = 0,
  frequency_penalty = 0,
  logit_bias = NULL,
  user = NULL,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{model}{required; defaults to \code{"gpt-3.5-turbo"}; a length one character
vector, one among \code{"gpt-3.5-turbo"} and \code{"gpt-3.5-turbo-0301"}.}

\item{messages}{required; defaults to \code{NULL}; a list in the following
format: \verb{list(list("role" = "user", "content" = "Hey! How old are you?")}}

\item{temperature}{required; defaults to \code{1}; a length one numeric vector
with the value between \code{0} and \code{2}.}

\item{top_p}{required; defaults to \code{1}; a length one numeric vector with the
value between \code{0} and \code{1}.}

\item{n}{required; defaults to \code{1}; a length one numeric vector with the
integer value greater than \code{0}.}

\item{stream}{required; defaults to \code{FALSE}; a length one logical vector.
\strong{Currently is not implemented.}}

\item{stop}{optional; defaults to \code{NULL}; a character vector of length
between one and four.}

\item{max_tokens}{required; defaults to \verb{(4096 - prompt tokens)}; a length
one numeric vector with the integer value greater than \code{0}.}

\item{presence_penalty}{required; defaults to \code{0}; a length one numeric
vector with a value between \code{-2} and \code{2}.}

\item{frequency_penalty}{required; defaults to \code{0}; a length one numeric
vector with a value between \code{-2} and \code{2}.}

\item{logit_bias}{optional; defaults to \code{NULL}; a named list.}

\item{user}{optional; defaults to \code{NULL}; a length one character vector.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, elements of which contain chat completion(s) and
supplementary information.
}
\description{
Creates a completion for the chat message. See \href{https://platform.openai.com/docs/api-reference/chat/create}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://platform.openai.com/docs/api-reference/chat/create}{official documentation}.
}
\examples{
\dontrun{
create_chat_completion(
   messages = list(
       list(
           "role" = "system",
           "content" = "You are a helpful assistant."
       ),
       list(
           "role" = "user",
           "content" = "Who won the world series in 2020?"
       ),
       list(
           "role" = "assistant",
           "content" = "The Los Angeles Dodgers won the World Series in 2020."
       ),
       list(
           "role" = "user",
           "content" = "Where was it played?"
       )
   )
)
}
}
