% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkMap.R
\name{networkMap}
\alias{networkMap}
\title{Create a leaflet map of air quality measurement network sites}
\usage{
networkMap(
  source = "aurn",
  control,
  date = Sys.Date(),
  cluster = TRUE,
  provider = "OpenStreetMap"
)
}
\arguments{
\item{source}{The data source for the meta data to be passed to
\code{\link[openair:importMeta]{openair::importMeta()}}. Can be \dQuote{aurn}, \dQuote{saqn} (or
\dQuote{saqd}), \dQuote{aqe}, \dQuote{waqn}, \dQuote{ni}, \dQuote{kcl} or
\dQuote{europe}.}

\item{control}{Option to add a "layer control" menu to allow readers to
select between different site types. Can choose between effectively any
column in the \code{\link[openair:importMeta]{openair::importMeta()}} output, such as \dQuote{variable},
\dQuote{site_type}, or \dQuote{agglomeration}.}

\item{date}{By default, \code{\link[=networkMap]{networkMap()}} visualises sites and pollutants which
are currently operational. Specifying \code{date} will visualise sites
which were operational at the chosen date. Dates should be provided in the
\dQuote{YYYY-MM-DD} format. Alternatively, a single year can be provided
(\dQuote{YYYY}) and \code{\link[=networkMap]{networkMap()}} will visualise sites which were
operational at the \emph{end} of that year (December 31st).}

\item{cluster}{When \code{cluster = TRUE}, markers are clustered together.
This may be useful for sources like \dQuote{kcl} where there are many
markers very close together. Defaults to \code{TRUE}, and is forced to be
\code{TRUE} when \code{source = "europe"} due to the large number of sites.}

\item{provider}{The base map to be used. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used.}
}
\value{
A leaflet object.
}
\description{
This function uses \code{\link[openair:importMeta]{openair::importMeta()}} to obtain metadata for measurement
sites and creates an attractive \code{leaflet} map.
}
\examples{
\dontrun{
networkMap(source = "aurn", control = "site_type")
}

}
