% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traj_trajLevelMap.R
\name{trajLevelMapStatic}
\alias{trajLevelMapStatic}
\title{Trajectory level plots in \code{ggplot2}}
\usage{
trajLevelMapStatic(
  data,
  longitude = "lon",
  latitude = "lat",
  pollutant,
  facet = "default",
  smooth = FALSE,
  statistic = "frequency",
  percentile = 90,
  lon.inc = 1,
  lat.inc = 1,
  min.bin = 1,
  .combine = NA,
  sigma = 1.5,
  alpha = 0.5,
  tile.border = NA,
  xlim = NULL,
  ylim = NULL,
  crs = sf::st_crs(4326),
  map = TRUE,
  map.fill = "grey85",
  map.colour = "grey75",
  map.alpha = 0.8,
  map.lwd = 0.5,
  map.lty = 1,
  ...
)
}
\arguments{
\item{data}{Data frame, the result of importing a trajectory file using
\code{\link[openair:importTraj]{openair::importTraj()}}.}

\item{latitude, longitude}{The decimal latitude/longitude.}

\item{pollutant}{Pollutant to be plotted. By default the trajectory height is
used.}

\item{facet}{Used for splitting the trajectories into different panels.
Passed to \code{\link[openair:cutData]{openair::cutData()}}.}

\item{smooth}{Should the trajectory surface be smoothed? Defaults to \code{FALSE}.
Note that smoothing may cause the plot to render slower, so consider
setting \code{crs} to \code{sf::st_crs(4326)} or \code{NULL}.}

\item{statistic}{For \code{trajLevel}. By default the function will plot the
trajectory frequencies.

For \code{trajLevel}, the argument \code{method = "hexbin"} can be used. In
this case hexagonal binning of the trajectory \emph{points} (i.e. a point
every three hours along each back trajectory). The plot then shows the
trajectory frequencies uses hexagonal binning. This is an alternative way
of viewing trajectory frequencies compared with \code{statistic =
  "frequency"}.

There are also various ways of plotting concentrations.

It is also possible to set \code{statistic = "difference"}. In this case
trajectories where the associated concentration is greater than
\code{percentile} are compared with the the full set of trajectories to
understand the differences in frequencies of the origin of air masses. The
comparison is made by comparing the percentage change in gridded
frequencies. For example, such a plot could show that the top 10\\% of
concentrations of PM10 tend to originate from air-mass origins to the east.

If \code{statistic = "pscf"} then a Potential Source Contribution Function
map is produced. If \code{statistic = "cwt"} then concentration weighted
trajectories are plotted.

If \code{statistic = "cwt"} then the Concentration Weighted Trajectory
approach is used. See details.}

\item{percentile}{For \code{trajLevel}. The percentile concentration of
\code{pollutant} against which the all trajectories are compared.}

\item{lon.inc}{The longitude-interval to be used for binning data for
\code{trajLevel}.}

\item{lat.inc}{The latitude-interval to be used for binning data when
\code{trajLevel}.}

\item{min.bin}{For \code{trajLevel} the minimum number of unique points in a
grid cell. Counts below \code{min.bin} are set as missing. For
\code{trajLevel} gridded outputs.}

\item{.combine}{When statistic is "SQTBA" it is possible to combine lots of
receptor locations to derive a single map. \code{.combine} identifies the
column that differentiates different sites (commonly a column named
\code{site}). Note that individual site maps are normalised first by
dividing by their mean value.}

\item{sigma}{For the SQTBA approach \code{sigma} determines the amount of
back trajectory spread based on the Gaussian plume equation. Values in the
literature suggest 5.4 km after one hour. However, testing suggests lower
values reveal source regions more effectively while not introducing too
much noise.}

\item{alpha}{Opacity of the tiles. Must be between \code{0} and \code{1}.}

\item{tile.border}{Colour to use for the border of binned tiles. Defaults to
\code{NA}, which draws no border.}

\item{xlim, ylim}{The x- and y-limits of the plot. If \code{NULL}, limits will be
estimated based on the lat/lon ranges of the input data.}

\item{crs}{The coordinate reference system (CRS) into which all data should
be projected before plotting. Defaults to latitude/longitude
(\code{sf::st_crs(4326)}).}

\item{map}{Should a base map be drawn? Defaults to \code{TRUE}.}

\item{map.fill}{Colour to use to fill the polygons of the base map (see
\code{colors()}).}

\item{map.colour}{Colour to use for the polygon borders of the base map (see
\code{colors()}).}

\item{map.alpha}{Transparency of the base map polygons. Must be between \code{0}
(fully transparent) and \code{1} (fully opaque).}

\item{map.lwd}{Line width of the base map polygon borders.}

\item{map.lty}{Line type of the base map polygon borders. See
\code{\link[ggplot2:scale_linetype]{ggplot2::scale_linetype()}} for common examples.}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:ggsf]{ggplot2::coord_sf}}
  \describe{
    \item{\code{expand}}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}
    \item{\code{datum}}{CRS that provides datum to use when generating graticules.}
    \item{\code{label_graticule}}{Character vector indicating which graticule lines should be labeled
where. Meridians run north-south, and the letters \code{"N"} and \code{"S"} indicate that
they should be labeled on their north or south end points, respectively.
Parallels run east-west, and the letters \code{"E"} and \code{"W"} indicate that they
should be labeled on their east or west end points, respectively. Thus,
\code{label_graticule = "SW"} would label meridians at their south end and parallels at
their west end, whereas \code{label_graticule = "EW"} would label parallels at both
ends and meridians not at all. Because meridians and parallels can in general
intersect with any side of the plot panel, for any choice of \code{label_graticule} labels
are not guaranteed to reside on only one particular side of the plot panel. Also,
\code{label_graticule} can cause labeling artifacts, in particular if a graticule line
coincides with the edge of the plot panel. In such circumstances, \code{label_axes} will
generally yield better results and should be used instead.

This parameter can be used alone or in combination with \code{label_axes}.}
    \item{\code{label_axes}}{Character vector or named list of character values
specifying which graticule lines (meridians or parallels) should be labeled on
which side of the plot. Meridians are indicated by \code{"E"} (for East) and
parallels by \code{"N"} (for North). Default is \code{"--EN"}, which specifies
(clockwise from the top) no labels on the top, none on the right, meridians
on the bottom, and parallels on the left. Alternatively, this setting could have been
specified with \code{list(bottom = "E", left = "N")}.

This parameter can be used alone or in combination with \code{label_graticule}.}
    \item{\code{lims_method}}{Method specifying how scale limits are converted into
limits on the plot region. Has no effect when \code{default_crs = NULL}.
For a very non-linear CRS (e.g., a perspective centered
around the North pole), the available methods yield widely differing results, and
you may want to try various options. Methods currently implemented include \code{"cross"}
(the default), \code{"box"}, \code{"orthogonal"}, and \code{"geometry_bbox"}. For method \code{"cross"},
limits along one direction (e.g., longitude) are applied at the midpoint of the
other direction (e.g., latitude). This method avoids excessively large limits for
rotated coordinate systems but means that sometimes limits need to be expanded a
little further if extreme data points are to be included in the final plot region.
By contrast, for method \code{"box"}, a box is generated out of the limits along both directions,
and then limits in projected coordinates are chosen such that the entire box is
visible. This method can yield plot regions that are too large. Finally, method
\code{"orthogonal"} applies limits separately along each axis, and method
\code{"geometry_bbox"} ignores all limit information except the bounding boxes of any
objects in the \code{geometry} aesthetic.}
    \item{\code{ndiscr}}{Number of segments to use for discretising graticule lines;
try increasing this number when graticules look incorrect.}
    \item{\code{default}}{Is this the default coordinate system? If \code{FALSE} (the default),
then replacing this coordinate system with another one creates a message alerting
the user that the coordinate system is being replaced. If \code{TRUE}, that warning
is suppressed.}
    \item{\code{clip}}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins. If
limits are set via \code{xlim} and \code{ylim} and some data points fall outside those
limits, then those data points may show up in places such as the axes, the
legend, the plot title, or the plot margins.}
  }}
}
\value{
A \code{ggplot2} plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function plots back trajectories on a \code{ggplot2} map. This function
requires that data are imported using the \code{\link[openair:importTraj]{openair::importTraj()}} function.
It is a \code{ggplot2} implementation of \code{\link[openair:trajLevel]{openair::trajLevel()}} with many of the
same arguments, which should be more flexible for post-hoc changes.
}
\seealso{
the original \code{\link[openair:trajLevel]{openair::trajLevel()}}

\code{\link[=trajLevelMap]{trajLevelMap()}} for the interactive \code{leaflet} equivalent of
\code{\link[=trajLevelMapStatic]{trajLevelMapStatic()}}

Other static trajectory maps: 
\code{\link{trajMapStatic}()}
}
\concept{static trajectory maps}
