
<!-- README.md is generated from README.Rmd. Please edit that file -->

# openairmaps: tools to create maps of air pollution data <img src="man/figures/logo.png" alt="the openairmaps logo. It shows a stylised pollution rose overlaid with a typical teardrop shaped map marker." align="right" height="134"/>

<!-- badges: start -->

[![R-CMD-check](https://github.com/davidcarslaw/openairmaps/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/davidcarslaw/openairmaps/actions/workflows/R-CMD-check.yaml)
[![CRAN
status](https://www.r-pkg.org/badges/version/openairmaps)](https://CRAN.R-project.org/package=openairmaps)

<!-- badges: end -->

The main goal of `{openairmaps}` is to combine the robust analytical
methods found in [`{openair}`](https://davidcarslaw.github.io/openair/)
on a range of dynamic and static maps. Core functionality includes
visualising UK AQ networks (`networkMap()`), putting “polar directional
markers” on maps (e.g., `polarMap()`) and overlaying HYSPLIT
trajectories on maps (e.g., `trajMap()`), all using the `{leaflet}`
package. Static equivalents of most functions are also available for
insertion into traditional reports and academic articles.

## Installation

You can install the release version of `{openairmaps}` from CRAN with:

``` r
install.packages("openairmaps")
```

You can install the development version of `{openairmaps}` from GitHub
with:

``` r
# install.packages("pak")
pak::pak("davidcarslaw/openairmaps")
```

## Documentation

All functions in `{openairmaps}` are thoroughly documented. The
[openairmaps website](https://davidcarslaw.github.io/openairmaps/)
contains all documentation and a change log of new features. There are
also many examples of `{openairmaps}` functionality the [openair
book](https://bookdown.org/david_carslaw/openair/sections/maps/maps-overview.html),
which goes into great detail about its various functions.

<img src="man/figures/README-patchwork.png" alt="An assembly of openairmaps maps, all of which are screenshots of dynamic leaflet maps. Top right: bivaraite polar plots. Bottom right: HYSPLIT trajectories. Right: markers displaying the locations of UK AURN sites." width="100%" />

## The `{openair}` toolkit

- [`{openair}`](https://davidcarslaw.github.io/openair/): Import,
  analyse, and visualise air quality and atmospheric composition data.

- [`{worldmet}`](https://davidcarslaw.github.io/worldmet/): Access world
  meteorological data from NOAA’s Integrated Surface Database.

- [`{openairmaps}`](https://davidcarslaw.github.io/openairmaps/):
  Visualise air quality data on interactive and static maps.

- [`{deweather}`](https://davidcarslaw.github.io/deweather/): Use
  machine learning to remove the effects of meteorology on air quality
  time series.
