% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user.R
\name{active_connection}
\alias{active_connection}
\title{Active Connection}
\usage{
active_connection(con = NULL)
}
\arguments{
\item{con}{optional \code{\link{OpenEOClient}} to set, if omitted or NULL the currently active 
connection is returned}
}
\value{
\code{\link{OpenEOClient}}
}
\description{
The function gets or sets the currently active connection to an openEO service. Usually, the
active connection is set when calling the \code{\link{connect}} function. Just the last 
connection is set as active.
An application for the active connection is the optional connection within all the functions
that interact with the openEO service and require a connection. If the connection is omitted 
in the function, this function is called in order to try to fetch a connection. If you 
want to operate on multiple services at once, you should use an explicit connection.
}
\examples{
\dontrun{
# Note: all URLs and credentials are arbitrary
con1 = connect("https://first.openeo-backend.com")
con2 = connect("https://second.openeo-backend.com")

active_connection() # this will be con2, the last connected backend

active_connection(con = con1) # sets the first connection as active, so it does not have to 
# be passed to all functions

active_connection() # this will now return the previous set connection con1
}

}
\seealso{
\code{\link{connect}}
}
