% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-student_housing.R
\docType{data}
\name{student_housing}
\alias{student_housing}
\title{Community college housing (simulated data, 2015)}
\format{
A data frame with 175 observations on the following variable.
\describe{
\item{price}{Monthly housing price, simulated.}
}
}
\usage{
student_housing
}
\description{
These are simulated data and intended to represent housing prices of
students at a college.
}
\examples{

set.seed(5)
generate_student_housing <- data.frame(
  price = round(rnorm(175, 515, 65) + exp(rnorm(175, 4.2, 1)))
)
hist(student_housing$price, 20)
t.test(student_housing$price)
mean(student_housing$price)
sd(student_housing$price)
identical(student_housing, generate_student_housing)
}
\keyword{datasets}
