% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weather_history.R
\name{weather_history}
\alias{weather_history}
\title{Retrieve historical weather data from the Open-Meteo API}
\usage{
weather_history(
  location,
  start,
  end,
  hourly = NULL,
  daily = NULL,
  response_units = NULL,
  model = NULL,
  timezone = "auto"
)
}
\arguments{
\item{location}{Required. The location for which data will be retrieved.
Supplied as either a \code{c(latitude,longitude)} WGS84 coordinate pair or a
place name string (with co-ordinates obtained via \code{\link[=geocode]{geocode()}}).}

\item{start, end}{Required. Start and end dates in ISO 8601 (e.g.
"2020-12-31").}

\item{hourly, daily}{At least one required. A weather variable accepted by the
API, or list thereof. See details below.}

\item{response_units}{Supply to convert temperature, windspeed, or
precipitation units. This defaults to: \verb{list(temperature_unit = "celsius",}
\verb{windspeed_unit = "kmh", precipitation_unit = "mm")}}

\item{model}{Supply to specify a model for re-analysis.}

\item{timezone}{specify timezone for time data as a string, i.e.
"australia/sydney" (defaults to "auto", the timezone local to the specified
\code{location}).}
}
\value{
Specified weather forecast data for the given location and time
}
\description{
\code{weather_history()} calls the Open-Meteo Historical Weather API to obtain
weather data for a given location and historical time period.
}
\details{
You will need to specify at least one weather variable, such as temperature,
that you want historical data for. These variables have been sampled or
aggregated at \emph{hourly} or \emph{daily} intervals, and can be supplied as a list to
request multiple variables over the same time period.

Example \emph{Hourly} historical weather variables include:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{temperature_2m} \tab Air temperature at 2 meters above ground \cr
   \code{precipitation} \tab Sum of rain, showers, and snow over the preceding hour \cr
   \code{windspeed_10m} \tab Wind speed at 10 meters above ground \cr
   \code{cloudcover} \tab Total cloud cover as an area fraction \cr
   \code{pressure_msl} \tab Atmospheric air pressure at mean sea level \cr
}


Example \emph{Daily} historical weather variables include:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{temperature_2m_max} \tab Maximum daily air temperature at 2 meters above ground \cr
   \code{precipitation_sum} \tab Sum of rain, showers, and snow over the preceding day \cr
   \code{windspeed_10m_max} \tab Maximum daily wind speed at 10 meters above ground \cr
}


Full documentation for the historical weather API is available at:
\url{https://open-meteo.com/en/docs/historical-weather-api}

You can also call \code{\link[=weather_variables]{weather_variables()}} to retrieve an (incomplete) shortlist
of valid hourly and daily weather variables.
}
\examples{
\donttest{
# obtain cloud cover history for London over 2020
weather_history("London",
  start = "2020-01-01",
  end = "2021-12-31",
  hourly = "cloudcover"
)
}
}
