% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names.R
\name{get_instrument_names}
\alias{get_instrument_names}
\alias{get_sample_names}
\alias{get_channel_names}
\alias{get_pattern_names}
\alias{get_order_names}
\alias{get_subsong_names}
\title{Get \code{openmpt} module element names}
\usage{
get_instrument_names(mod, ...)

get_sample_names(mod, ...)

get_channel_names(mod, ...)

get_pattern_names(mod, ...)

get_order_names(mod, ...)

get_subsong_names(mod, ...)
}
\arguments{
\item{mod}{A tracker module object of class \code{openmpt}.}

\item{...}{Ignored}
}
\value{
A \code{vector} of strings with names
}
\description{
Get names of elements in an \code{openmpt} class object. Use \code{\link[=get_metadata]{get_metadata()}} to get a module's name.
}
\examples{
mod <- demo_mod()
get_subsong_names(mod)
get_channel_names(mod)
get_pattern_names(mod)
get_order_names(mod)
get_instrument_names(mod)
get_sample_names(mod)[1:8]
}
