% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_key}
\alias{read_cert}
\alias{read_cert_bundle}
\alias{read_key}
\alias{read_pubkey}
\title{Parsing keys and certificates}
\usage{
read_key(file, password = askpass, der = is.raw(file))

read_pubkey(file, der = is.raw(file))

read_cert(file, der = is.raw(file))

read_cert_bundle(file)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data (a string for
pem/ssh format, or a raw vector in der format)}

\item{password}{A string or callback function to read protected keys}

\item{der}{set to \code{TRUE} if \code{file} is in binary DER format}
}
\value{
An object of class \code{cert}, \code{key} or \code{pubkey} which holds the data
in binary DER format and can be decomposed using \code{as.list}.
}
\description{
The \code{read_key} function (private keys) and \code{read_pubkey} (public keys)
support both SSH pubkey format and OpenSSL PEM format (base64 data with a \code{--BEGIN}
and \code{---END} header), and automatically convert where necessary. The functions assume
a single key per file except for \code{read_cert_bundle} which supports PEM files
with multiple certificates.
}
\details{
Most versions of OpenSSL support at least RSA, DSA and ECDSA keys. Certificates must
conform to the X509 standard.

The \code{password} argument is needed when reading keys that are protected with a
passphrase. It can either be a string containing the passphrase, or a custom calback
function that will be called by OpenSSL to read the passphrase. The function should
take one argument (a string with a message) and return a string. The default is to
use \code{readline} which will prompt the user in an interactive R session.
}
\examples{
\dontrun{# Read private key
key <- read_key("~/.ssh/id_rsa")
as.list(key)

# Read public key
pubkey <- read_pubkey("~/.ssh/id_rsa.pub")
as.list(pubkey)

# Read certificates
txt <- readLines("http://curl.haxx.se/ca/cacert.pem")
bundle <- read_cert_bundle(txt)
print(bundle)
}
}
\seealso{
\link{download_ssl_cert}
}

