% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-worksheet.R
\name{wbWorksheet}
\alias{wbWorksheet}
\title{R6 class for a Workbook Worksheet}
\value{
The \code{wbWorksheet} object
}
\description{
R6 class for a Workbook Worksheet

R6 class for a Workbook Worksheet
}
\details{
A Worksheet
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{sheetPr}}{sheetPr}

\item{\code{dimension}}{dimension}

\item{\code{sheetViews}}{sheetViews}

\item{\code{sheetFormatPr}}{sheetFormatPr}

\item{\code{sheet_data}}{sheet_data}

\item{\code{cols_attr}}{cols_attr}

\item{\code{autoFilter}}{autoFilter}

\item{\code{mergeCells}}{mergeCells}

\item{\code{conditionalFormatting}}{conditionalFormatting}

\item{\code{dataValidations}}{dataValidations}

\item{\code{freezePane}}{freezePane}

\item{\code{hyperlinks}}{hyperlinks}

\item{\code{sheetProtection}}{sheetProtection}

\item{\code{pageMargins}}{pageMargins}

\item{\code{pageSetup}}{pageSetup}

\item{\code{headerFooter}}{headerFooter}

\item{\code{rowBreaks}}{rowBreaks}

\item{\code{colBreaks}}{colBreaks}

\item{\code{drawing}}{drawing}

\item{\code{legacyDrawing}}{legacyDrawing}

\item{\code{legacyDrawingHF}}{legacyDrawingHF}

\item{\code{oleObjects}}{oleObjects}

\item{\code{tableParts}}{tableParts}

\item{\code{extLst}}{extLst}

\item{\code{cellWatches}}{cellWatches}

\item{\code{controls}}{controls}

\item{\code{customProperties}}{customProperties}

\item{\code{customSheetViews}}{customSheetViews}

\item{\code{dataConsolidate}}{dataConsolidate}

\item{\code{drawingHF}}{drawingHF}

\item{\code{ignoredErrors}}{ignoredErrors}

\item{\code{phoneticPr}}{phoneticPr}

\item{\code{picture}}{picture}

\item{\code{printOptions}}{printOptions}

\item{\code{protectedRanges}}{protectedRanges}

\item{\code{scenarios}}{scenarios}

\item{\code{sheetCalcPr}}{sheetCalcPr}

\item{\code{smartTags}}{smartTags}

\item{\code{sortState}}{sortState}

\item{\code{webPublishItems}}{webPublishItems}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-wbWorksheet-new}{\code{wbWorksheet$new()}}
\item \href{#method-wbWorksheet-get_prior_sheet_data}{\code{wbWorksheet$get_prior_sheet_data()}}
\item \href{#method-wbWorksheet-get_post_sheet_data}{\code{wbWorksheet$get_post_sheet_data()}}
\item \href{#method-wbWorksheet-unfold_cols}{\code{wbWorksheet$unfold_cols()}}
\item \href{#method-wbWorksheet-fold_cols}{\code{wbWorksheet$fold_cols()}}
\item \href{#method-wbWorksheet-clean_sheet}{\code{wbWorksheet$clean_sheet()}}
\item \href{#method-wbWorksheet-add_page_break}{\code{wbWorksheet$add_page_break()}}
\item \href{#method-wbWorksheet-append}{\code{wbWorksheet$append()}}
\item \href{#method-wbWorksheet-add_sparklines}{\code{wbWorksheet$add_sparklines()}}
\item \href{#method-wbWorksheet-clone}{\code{wbWorksheet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-new"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{wbWorksheet} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$new(
  gridLines = TRUE,
  rowColHeaders = TRUE,
  tabSelected = FALSE,
  tabColour = NULL,
  zoom = 100,
  oddHeader = NULL,
  oddFooter = NULL,
  evenHeader = NULL,
  evenFooter = NULL,
  firstHeader = NULL,
  firstFooter = NULL,
  paperSize = 9,
  orientation = "portrait",
  hdpi = 300,
  vdpi = 300
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gridLines}}{gridLines}

\item{\code{rowColHeaders}}{rowColHeaders}

\item{\code{tabSelected}}{tabSelected}

\item{\code{tabColour}}{tabColour}

\item{\code{zoom}}{zoom}

\item{\code{oddHeader}}{oddHeader}

\item{\code{oddFooter}}{oddFooter}

\item{\code{evenHeader}}{evenHeader}

\item{\code{evenFooter}}{evenFooter}

\item{\code{firstHeader}}{firstHeader}

\item{\code{firstFooter}}{firstFooter}

\item{\code{paperSize}}{paperSize}

\item{\code{orientation}}{orientation}

\item{\code{hdpi}}{hdpi}

\item{\code{vdpi}}{vdpi}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{wbWorksheet} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-get_prior_sheet_data"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-get_prior_sheet_data}{}}}
\subsection{Method \code{get_prior_sheet_data()}}{
Get prior sheet data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$get_prior_sheet_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector of xml
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-get_post_sheet_data"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-get_post_sheet_data}{}}}
\subsection{Method \code{get_post_sheet_data()}}{
Get post sheet data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$get_post_sheet_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector of xml
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-unfold_cols"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-unfold_cols}{}}}
\subsection{Method \code{unfold_cols()}}{
unfold \verb{<cols ..>} node to dataframe. \verb{<cols><col ..>} are compressed.
Only columns with attributes are written to the file. This function
unfolds them so that each cell beginning with the "A" to the last one
found in cc gets a value.
TODO might extend this to match either largest cc or largest col. Could
be that "Z" is formatted, but the last value is written to "Y".
TODO might replace the xml nodes with the data frame?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$unfold_cols()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The column data frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-fold_cols"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-fold_cols}{}}}
\subsection{Method \code{fold_cols()}}{
fold the column dataframe back into a node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$fold_cols(col_df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{col_df}}{the column data frame}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-clean_sheet"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-clean_sheet}{}}}
\subsection{Method \code{clean_sheet()}}{
clean sheet (remove all values)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$clean_sheet(
  numbers = TRUE,
  characters = TRUE,
  styles = TRUE,
  merged_cells = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{numbers}}{remove all numbers}

\item{\code{characters}}{remove all characters}

\item{\code{styles}}{remove all styles}

\item{\code{merged_cells}}{remove all merged_cells}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-add_page_break"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-add_page_break}{}}}
\subsection{Method \code{add_page_break()}}{
add page break
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$add_page_break(row = NULL, col = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{row}}{row}

\item{\code{col}}{col}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-append"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-append}{}}}
\subsection{Method \code{append()}}{
append a field.  Intended for internal use only.  Not
guaranteed to remain a public method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$append(field, value = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{a field name}

\item{\code{value}}{a new value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-add_sparklines"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-add_sparklines}{}}}
\subsection{Method \code{add_sparklines()}}{
add sparkline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$add_sparklines(sparklines)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sparklines}}{sparkline created by \code{create_sparkline()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
