% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R, R/write.R
\name{wb_add_data}
\alias{wb_add_data}
\alias{write_data}
\title{Add data to a worksheet}
\usage{
wb_add_data(
  wb,
  sheet = current_sheet(),
  x,
  startCol = 1,
  startRow = 1,
  dims = rowcol_to_dims(startRow, startCol),
  array = FALSE,
  xy = NULL,
  colNames = TRUE,
  rowNames = FALSE,
  withFilter = FALSE,
  name = NULL,
  sep = ", ",
  applyCellStyle = TRUE,
  removeCellStyle = FALSE,
  na.strings,
  inline_strings = TRUE
)

write_data(
  wb,
  sheet,
  x,
  startCol = 1,
  startRow = 1,
  dims = rowcol_to_dims(startRow, startCol),
  array = FALSE,
  xy = NULL,
  colNames = TRUE,
  rowNames = FALSE,
  withFilter = FALSE,
  sep = ", ",
  name = NULL,
  applyCellStyle = TRUE,
  removeCellStyle = FALSE,
  na.strings,
  inline_strings = TRUE
)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet.}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{x}{Object to be written. For classes supported look at the examples.}

\item{startCol}{A vector specifying the starting column to write to.}

\item{startRow}{A vector specifying the starting row to write to.}

\item{dims}{Spreadsheet dimensions that will determine startCol and startRow: "A1", "A1:B2", "A:B"}

\item{array}{A bool if the function written is of type array}

\item{xy}{An alternative to specifying \code{startCol} and
\code{startRow} individually.  A vector of the form
\code{c(startCol, startRow)}.}

\item{colNames}{If \code{TRUE}, column names of x are written.}

\item{rowNames}{If \code{TRUE}, data.frame row names of x are written.}

\item{withFilter}{If \code{TRUE}, add filters to the column name row. NOTE can only have one filter per worksheet.}

\item{name}{If not NULL, a named region is defined.}

\item{sep}{Only applies to list columns. The separator used to collapse list columns to a character vector e.g. sapply(x$list_column, paste, collapse = sep).}

\item{applyCellStyle}{apply styles when writing on the sheet}

\item{removeCellStyle}{if writing into existing cells, should the cell style be removed?}

\item{na.strings}{optional na.strings argument. if missing #N/A is used. If NULL no cell value is written, if character or numeric this is written (even if NA is part of numeric data)}

\item{inline_strings}{write characters as inline strings}
}
\value{
A clone of `wb``

invisible(0)
}
\description{
Add data to worksheet with optional styling.

Write an object to worksheet with optional styling.
}
\details{
Formulae written using write_formula to a Workbook object will not get picked up by read_xlsx().
This is because only the formula is written and left to Excel to evaluate the formula when the file is opened in Excel.
The string \code{"_openxlsx_NA"} is reserved for \code{openxlsx2}. If the data frame contains this string, the output will be broken.

Formulae written using write_formula to a Workbook object will not get picked up by read_xlsx().
This is because only the formula is written and left to Excel to evaluate the formula when the file is opened in Excel.
The string \code{"_openxlsx_NA"} is reserved for \code{openxlsx2}. If the data frame contains this string, the output will be broken.
}
\examples{

## See formatting vignette for further examples.

## Options for default styling (These are the defaults)
options("openxlsx2.dateFormat" = "mm/dd/yyyy")
options("openxlsx2.datetimeFormat" = "yyyy-mm-dd hh:mm:ss")
options("openxlsx2.numFmt" = NULL)

#####################################################################################
## Create Workbook object and add worksheets
wb <- wb_workbook()

## Add worksheets
wb$add_worksheet("Cars")
wb$add_worksheet("Formula")

x <- mtcars[1:6, ]
wb$add_data("Cars", x, startCol = 2, startRow = 3, rowNames = TRUE)

#####################################################################################
## Hyperlinks
## - vectors/columns with class 'hyperlink' are written as hyperlinks'

v <- rep("https://CRAN.R-project.org/", 4)
names(v) <- paste0("Hyperlink", 1:4) # Optional: names will be used as display text
class(v) <- "hyperlink"
wb$add_data("Cars", x = v, xy = c("B", 32))

#####################################################################################
## Formulas
## - vectors/columns with class 'formula' are written as formulas'

df <- data.frame(
  x = 1:3, y = 1:3,
  z = paste(paste0("A", 1:3 + 1L), paste0("B", 1:3 + 1L), sep = "+"),
  stringsAsFactors = FALSE
)

class(df$z) <- c(class(df$z), "formula")

wb$add_data(sheet = "Formula", x = df)

###########################################################################
# update cell range and add mtcars
xlsxFile <- system.file("extdata", "inline_str.xlsx", package = "openxlsx2")
wb2 <- wb_load(xlsxFile)

# read dataset with inlinestr
wb_to_df(wb2)
# read_xlsx(wb2)
write_data(wb2, 1, mtcars, startCol = 4, startRow = 4)
wb_to_df(wb2)
}
\seealso{
\code{\link[=write_datatable]{write_datatable()}}

Other workbook wrappers: 
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_get_base_font}()},
\code{\link{wb_save}()},
\code{\link{wb_set_col_widths}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()},
\code{\link{workbook_grouping}},
\code{\link{ws_cell_merge}}
}
\concept{workbook wrappers}
