% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_filter}
\alias{wb_add_filter}
\title{Add column filters}
\usage{
wb_add_filter(wb, sheet = current_sheet(), rows, cols)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{rows}{A row number.}

\item{cols}{columns to add filter to.}
}
\description{
Add excel column filters to a worksheet
}
\details{
adds filters to worksheet columns, same as filter parameters in write_data.
write_datatable automatically adds filters to first row of a table.
NOTE Can only have a single filter per worksheet unless using tables.
}
\examples{
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")
wb$add_worksheet("Sheet 2")
wb$add_worksheet("Sheet 3")

wb$add_data(1, iris)
wb$add_filter(1, row = 1, cols = seq_along(iris))

## Equivalently
wb$add_data(2, x = iris, withFilter = TRUE)

## Similarly
wb$add_data_table(3, iris)
}
\seealso{
\code{\link[=write_data]{write_data()}}

\code{\link[=wb_add_filter]{wb_add_filter()}}
}
