% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWorkbook.R
\name{read_xlsx}
\alias{read_xlsx}
\title{Read from an Excel file or Workbook object}
\usage{
read_xlsx(
  xlsxFile,
  sheet,
  startRow = 1,
  startCol = NULL,
  rowNames = FALSE,
  colNames = TRUE,
  skipEmptyRows = FALSE,
  skipEmptyCols = FALSE,
  rows = NULL,
  cols = NULL,
  detectDates = TRUE,
  namedRegion,
  na.strings = "#N/A",
  na.numbers = NA,
  check.names = FALSE,
  sep.names = ".",
  fillMergedCells = FALSE,
  ...
)
}
\arguments{
\item{xlsxFile}{An xlsx file, Workbook object or URL to xlsx file.}

\item{sheet}{The name or index of the sheet to read data from.}

\item{startRow}{first row to begin looking for data.}

\item{startCol}{first column to begin looking for data.}

\item{rowNames}{If \code{TRUE}, first column of data will be used as row names.}

\item{colNames}{If \code{TRUE}, the first row of data will be used as column names.}

\item{skipEmptyRows}{If \code{TRUE}, empty rows are skipped else empty rows after the first row containing data
will return a row of NAs.}

\item{skipEmptyCols}{If \code{TRUE}, empty columns are skipped.}

\item{rows}{A numeric vector specifying which rows in the Excel file to read.
If NULL, all rows are read.}

\item{cols}{A numeric vector specifying which columns in the Excel file to read.
If NULL, all columns are read.}

\item{detectDates}{If \code{TRUE}, attempt to recognize dates and perform conversion.}

\item{namedRegion}{A named region in the Workbook. If not NULL startRow, rows and cols parameters are ignored.}

\item{na.strings}{A character vector of strings which are to be interpreted as NA. Blank cells will be returned as NA.}

\item{na.numbers}{A numeric vector of digits which are to be interpreted as NA. Blank cells will be returned as NA.}

\item{check.names}{logical. If TRUE then the names of the variables in the data frame
are checked to ensure that they are syntactically valid variable names}

\item{sep.names}{(unimplemented) One character which substitutes blanks in column names. By default, "."}

\item{fillMergedCells}{If TRUE, the value in a merged cell is given to all cells within the merge.}

\item{...}{additional arguments passed to \code{wb_to_df()}}
}
\value{
data.frame
}
\description{
Read data from an Excel file or Workbook object into a data.frame
}
\details{
Formulae written using write_formula to a Workbook object will not get picked up by read_xlsx().
This is because only the formula is written and left to be evaluated when the file is opened in Excel.
Opening, saving and closing the file with Excel will resolve this.
}
\examples{
xlsxFile <- system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2")
read_xlsx(xlsxFile = xlsxFile)
}
\seealso{
\code{\link[=wb_get_named_regions]{wb_get_named_regions()}} \code{\link[=wb_to_df]{wb_to_df()}}
}
