% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_workbook}
\alias{wb_workbook}
\title{Create a new Workbook object}
\usage{
wb_workbook(
  creator = NULL,
  title = NULL,
  subject = NULL,
  category = NULL,
  datetime_created = Sys.time(),
  theme = NULL,
  ...
)
}
\arguments{
\item{creator}{Creator of the workbook (your name). Defaults to login username or \code{options("openxlsx2.creator")} if set.}

\item{title, subject, category}{Workbook property, a string.}

\item{datetime_created}{The time of the workbook is created}

\item{theme}{Optional theme identified by string or number.
See \strong{Details} for options.}

\item{...}{additional arguments}
}
\value{
A \code{wbWorkbook} object
}
\description{
Initialize a \link{wbWorkbook} object. You can set workbook properties as well.
}
\details{
\code{theme} can be one of
"Atlas", "Badge", "Berlin", "Celestial", "Crop", "Depth", "Droplet",
"Facet", "Feathered", "Gallery", "Headlines", "Integral", "Ion",
"Ion Boardroom", "Madison", "Main Event", "Mesh", "Office Theme",
"Old Office Theme", "Organic", "Parallax", "Parcel", "Retrospect",
"Savon", "Slice", "Vapor Trail", "View", "Wisp", "Wood Type"
}
\examples{
## Create a new workbook
wb <- wb_workbook()

## Set Workbook properties
wb <- wb_workbook(
  creator  = "Me",
  title    = "Expense Report",
  subject  = "Expense Report - 2022 Q1",
  category = "sales"
)
}
\seealso{
Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()}
}
\concept{workbook wrappers}
