% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_font}
\alias{wb_add_font}
\title{Modify font in a cell region}
\usage{
wb_add_font(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  name = "Calibri",
  color = wb_color(hex = "FF000000"),
  size = "11",
  bold = "",
  italic = "",
  outline = "",
  strike = "",
  underline = "",
  charset = "",
  condense = "",
  extend = "",
  family = "",
  scheme = "",
  shadow = "",
  vert_align = "",
  ...
)
}
\arguments{
\item{wb}{A Workbook object}

\item{sheet}{the worksheet}

\item{dims}{the cell range}

\item{name}{Font name: default "Calibri"}

\item{color}{An object created by \code{\link[=wb_color]{wb_color()}}}

\item{size}{Font size: default "11",}

\item{bold}{bold, "single" or "double", default: ""}

\item{italic}{italic}

\item{outline}{outline}

\item{strike}{strike}

\item{underline}{underline}

\item{charset}{charset}

\item{condense}{condense}

\item{extend}{extend}

\item{family}{font family}

\item{scheme}{font scheme}

\item{shadow}{shadow}

\item{vert_align}{vertical alignment}

\item{...}{...}
}
\value{
A \code{wbWorkbook}, invisibly
}
\description{
Modify the font in a cell region with more precision
You can specify the font in a cell with other cell styling functions,
but \code{wb_add_font()} gives you more control.
}
\details{
\code{wb_add_font()} provides all the options openxml accepts for a font node,
not all have to be set. Usually \code{name}, \code{size} and \code{color} should be what the user wants.
}
\examples{
 wb <- wb_workbook() \%>\% wb_add_worksheet("S1") \%>\% wb_add_data("S1", mtcars)
 wb \%>\% wb_add_font("S1", "A1:K1", name = "Arial", color = wb_color(theme = "4"))
# With chaining
 wb <- wb_workbook()$add_worksheet("S1")$add_data("S1", mtcars)
 wb$add_font("S1", "A1:K1", name = "Arial", color = wb_color(theme = "4"))
}
\seealso{
Other styles: 
\code{\link{wb_add_border}()},
\code{\link{wb_add_cell_style}()},
\code{\link{wb_add_fill}()},
\code{\link{wb_add_named_style}()},
\code{\link{wb_add_numfmt}()},
\code{\link{wb_cell_style}}
}
\concept{styles}
